<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class EnsureFullAdmin
{
    public function handle(Request $request, Closure $next): Response
    {
        $user = Auth::user();

        if (! $user || ! $user->isFullAdmin()) {
            return redirect()->route('admin.dashboard')->withErrors([
                'email' => 'You do not have permission to access that section.',
            ]);
        }

        return $next($request);
    }
}
